#version 330

uniform mat4 world;
uniform mat4 worldview;
uniform mat4 worldviewproj;
uniform mat4 invworldview;
uniform vec4 blend;
uniform vec4 edges;

in vec4 vertex;
in vec4 normal;
in vec4 uv0;
in vec4 colour;
	
out vec4 pos;
out vec3 norm;
out vec4 uv;
out vec4 vertexColor;
out vec4 worldPos;
out vec3 tang;
out vec3 binorm;
 
void main() 
{
	vec4 p = vec4(vertex.xy, invworldview[3][2], 1.0);
	vec3 dv = (worldview*p).xyz;
	float d2 = dot(dv, dv);
	float d = sqrt(d2);
	float f = 0.0;
	if(uv0.x > 0 && uv0.x < 1.0 && uv0.y > 0 && uv0.y < 1.0) {
		clamp((d - blend.x)*blend.z, 0.0, 1.0);
	}
	if(uv0.x == 1.0) {
		f = max(edges.x, f);
	} else if(uv0.x == 0.0) {
		f = max(edges.z, f);
	}
	if(uv0.y == 1.0) {
		f = max(edges.y, f);
	} else if(uv0.y == 0.0) {
		f = max(edges.w, f);
	}
	vec4 v0 = vec4(mix(vertex.xyz, vertex.xyw, f), 1.0);
	pos = worldview*v0;
	vec3 N = vec3(normal.xy, 0);
	N.z = sqrt(1.0 - dot(N.xy, N.xy));
	vec3 N2 = vec3(normal.zw, 0);
	N2.z = sqrt(1.0 - dot(N2.xy, N2.xy));
	norm = mat3(worldview)*mix(N, N2, f);
	
	uv = uv0;
	vertexColor = colour;
	worldPos = world*v0;
	
	tang = normalize(cross(mat3(worldview)*vec3(0, -1, 0), norm));
	binorm = cross(norm, tang);
	
	gl_Position = worldviewproj*v0;
}
